<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Dompdf Settings
    |--------------------------------------------------------------------------
    | Adjust as needed for your project.
    */
    'show_warnings'  => false,
    'orientation'    => 'portrait',
    'remote_enabled' => true,

    'defines' => [

        // Font storage/cache
        'DOMPDF_FONT_DIR'    => storage_path('fonts/'),
        'DOMPDF_FONT_CACHE'  => storage_path('fonts/'),
        'font_dir'           => storage_path('fonts/'),
        'font_cache'         => storage_path('fonts/'),

        // Temp directory
        'DOMPDF_TEMP_DIR'    => sys_get_temp_dir(),

        // Restrict file access
        'DOMPDF_CHROOT'      => base_path(),

        // Rendering
        'DOMPDF_UNICODE_ENABLED'      => true,
        'DOMPDF_ENABLE_FONTSUBSETTING'=> false,
        'DOMPDF_PDF_BACKEND'          => 'CPDF',
        'DOMPDF_DEFAULT_MEDIA_TYPE'   => 'screen',
        'DOMPDF_DEFAULT_PAPER_SIZE'   => 'a4',
        'DOMPDF_DEFAULT_FONT'         => 'tahoma',
        'DOMPDF_DPI'                  => 96,

        // Features
        'DOMPDF_ENABLE_PHP'       => true,
        'DOMPDF_ENABLE_JAVASCRIPT'=> true,
        'DOMPDF_ENABLE_REMOTE'    => true,   // must be true to load external images/CSS
        'DOMPDF_ENABLE_CSS_FLOAT' => true,
        'DOMPDF_ENABLE_HTML5PARSER' => true,

        // Line height
        'DOMPDF_FONT_HEIGHT_RATIO' => 1.1,
    ],

];
