<?php

namespace App;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Auth\Passwords\CanResetPassword;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use CanResetPassword, HasRoles;

    protected $table = 'users';

    protected $fillable = [
        'first_name','last_name','email', 'password','username',
        'designation_id','property_id','rent_amount','telephone',
        'cell_no','status'
    ];

    protected $hidden = ['password', 'remember_token'];

    public function profile()
    {
        return $this->hasOne(Profile::class); 
    }

    public function designation()
    {
        return $this->belongsTo(Designation::class); 
    }

    public function bankAccount()
    {
        return $this->hasMany(BankAccount::class); 
    }

    public function document()
    {
        return $this->hasMany(Document::class); 
    }

    public function alias()
    {
        return $this->belongsTo(Alias::class); 
    }

    public function employeeAsset()
    {
        return $this->hasMany(EmployeeAsset::class,'employee_id'); 
    }

    public function dependent()
    {
        return $this->hasMany(Dependent::class); 
    }

    public function todo()
    {
        return $this->hasMany(Todo::class); 
    }

    public function task()
    {
        return $this->belongsToMany(Task::class,'assigned_tasks','user_id','task_id');
    }

    public function leave()
    {
        return $this->hasMany(Leave::class,'user_id'); 
    }

    public function award()
    {
        return $this->belongsToMany(Award::class,'assigned_award','user_id','award_id');
    }

    public function message()
    {
        return $this->hasMany(Message::class); 
    }

    public function clock()
    {
        return $this->hasMany(Clock::class); 
    }

    public function ticket()
    {
        return $this->hasMany(Ticket::class); 
    }

    public function payrollSlip()
    {
        return $this->hasMany(PayrollSlip::class); 
    }

    public function getFullNameAttribute()
    {
        return $this->first_name . " " . $this->last_name;
    }
}
