<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Validator;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Custom unique_with validation
    Validator::extend('unique_with', function ($attribute, $value, $parameters, $validator) {
        // The table is the first parameter
        $table = array_shift($parameters);

        // Build query
        $query = \DB::table($table);

        // Add all field conditions
        foreach ($parameters as $field) {
            $data = $validator->getData();
            if (! isset($data[$field])) {
                return false;
            }
            $query->where($field, $data[$field]);
        }

        // Finally check the attribute itself
        $exists = $query->where($attribute, $value)->exists();

        return ! $exists;
    });

    // Optional: nice message
    Validator::replacer('unique_with', function ($message, $attribute, $rule, $parameters) {
        return $message ?: "The combination of fields has already been taken.";
    });
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
