<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\JobController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ExpireListController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\LocationController;
use App\Http\Controllers\DesignationController;
use App\Http\Controllers\TrainingController;
use App\Http\Controllers\Manage_TrainingController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\SMSController;
use App\Http\Controllers\BankAccountController;
use App\Http\Controllers\DocumentController;
use App\Http\Controllers\DependentController;
use App\Http\Controllers\SalaryController;
use App\Http\Controllers\TemplateController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\TodoController;
use App\Http\Controllers\LeaveController;
use App\Http\Controllers\HolidayController;
use App\Http\Controllers\EmployeeAssetController;
use App\Http\Controllers\AssetController;
use App\Http\Controllers\AliasController;
use App\Http\Controllers\ClockController;
use App\Http\Controllers\InController;
use App\Http\Controllers\OutController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\Common_Report_Controller;
use App\Http\Controllers\Excel_Controller;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\PayrollController;
use App\Http\Controllers\TicketController;
use App\Http\Controllers\TicketCommentController;
use App\Http\Controllers\TicketNoteController;
use App\Http\Controllers\TicketAttachmentController;
use App\Http\Controllers\TaskController;
use App\Http\Controllers\CommentController;
use App\Http\Controllers\NoteController;
use App\Http\Controllers\AttachmentController;
use App\Http\Controllers\MessageController;
use App\Http\Controllers\AwardController;
use App\Http\Controllers\AwardTypeController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\ConfigController;
use App\Http\Controllers\CustomFieldController;
use App\Http\Controllers\LeaveTypeController;
use App\Http\Controllers\DocumentTypeController;
use App\Http\Controllers\SalaryTypeController;
use App\Http\Controllers\ExpenseHeadController;
use App\Http\Controllers\TemplateController as TemplateCtrl;
use App\Http\Controllers\SMSTemplateController;
use App\Http\Controllers\NoticeController;

/*
|--------------------------------------------------------------------------
| Guest Routes
|--------------------------------------------------------------------------
*/

Route::get('/', [AuthController::class, 'showLoginForm']);

Route::get('/apply', [JobController::class, 'apply']);
Route::post('/saveApplication', [JobController::class, 'saveApplication'])->name('job.saveApplication');

Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [AuthController::class, 'login']);
    Route::get('password/email', [AuthController::class, 'getEmail']);
    Route::post('password/email', [AuthController::class, 'postEmail']);
    Route::get('password/reset/{token}', [AuthController::class, 'getReset']);
    Route::post('password/reset', [AuthController::class, 'postReset']);

    $config = \App\Classes\Helper::getConfiguration();
    if (array_key_exists('installation_path', $config) && $config['installation_path'] == '') {
        Route::resource('install', \App\Http\Controllers\InstallController::class)->only(['index', 'store']);
    }
});

/*
|--------------------------------------------------------------------------
| Authenticated Routes
|--------------------------------------------------------------------------
*/

Route::middleware('auth')->group(function () {
    Route::get('dashboard', [DashboardController::class, 'index']);
    Route::get('expirelist', [ExpireListController::class, 'index']);
    Route::get('/logout', [AuthController::class, 'logout']);
    Route::get('/payments', [PaymentController::class, 'index']);

    // Languages
    Route::resource('language', LanguageController::class);
    Route::get('setLanguage/{locale}', [LanguageController::class, 'setLanguage']);
    Route::post('language/addWords', [LanguageController::class, 'addWords'])->name('language.addWords');
    Route::patch('language/updateTranslation/{id}', [LanguageController::class, 'updateTranslation'])->name('language.updateTranslation');

    // Departments, Locations, Designations
    Route::resource('department', DepartmentController::class);
    Route::resource('location', LocationController::class);
    Route::resource('designation', DesignationController::class);

    // Training
    Route::get('training/add', [TrainingController::class, 'add_training']);
    Route::get('training/manage', [TrainingController::class, 'add_new']);
    Route::get('training/report', [TrainingController::class, 'report']);
    Route::resource('manage_training', Manage_TrainingController::class);
    Route::get('training_type/{id}/edit', [TrainingController::class, 'edit']);
    Route::resource('training', TrainingController::class);

    // Employees
    Route::get('employee/create', [AuthController::class, 'showRegistrationForm']);
    Route::post('auth/register', [AuthController::class, 'register']);
    Route::resource('employee', EmployeeController::class)->except(['create', 'store']);
    Route::patch('users/profile/{id}', [EmployeeController::class, 'profileUpdate'])->name('employee.profileUpdate');
    Route::patch('users/sms/{id}', [SMSController::class, 'sendEmployeeSMS'])->name('employee.sendEmployeeSMS');

        
    // Salary
    Route::resource('salary', SalaryController::class)->only(['store','destroy']);
    Route::get('/employee/welcomeEmail/{user_id}/{token}', [TemplateController::class,'welcomeEmail']);

    // Jobs / Expenses / Todos / Leaves / Holidays
    Route::resource('job', JobController::class);
    Route::resource('expense', ExpenseController::class);
    Route::resource('todo', TodoController::class);
    Route::resource('leave', LeaveController::class);
    Route::post('leaveUpdateStatus', [LeaveController::class,'updateStatus'])->name('leave.updateStatus');
    Route::resource('holiday', HolidayController::class);

    // Assets
    Route::resource('employeeasset', EmployeeAssetController::class);
    Route::resource('asset', AssetController::class);
    Route::resource('alias', AliasController::class);

    // Clock / Attendance
    Route::get('clock/in/{token}', [ClockController::class,'in'])->name('clock.in');
    Route::get('clock/out/{token}', [ClockController::class,'out'])->name('clock.out');
    Route::any('attendance', [ClockController::class,'attendance'])->name('clock.attendance');
    Route::get('attendance_monthly', [ClockController::class,'attendanceMonthly']);
    Route::post('attendance_monthly', [ClockController::class,'attendanceMonthlyReport'])->name('clock.attendanceMonthlyReport');
    Route::post('uploadAttendance', [ClockController::class,'uploadAttendance'])->name('clock.uploadAttendance');
    Route::get('update_attendance', [ClockController::class,'updateAttendance']);
    Route::post('updateAttendance', [ClockController::class,'updateStaffAttendance'])->name('clock.updateAttendance');

    // Product In/Out/Settings
    Route::get('raw_m_in', [InController::class,'raw_m_in']);
    Route::get('caterory_in/{id}', [InController::class,'caterory_in']);
    Route::get('delete_product_in/{id}', [InController::class,'delete_product_in']);
    Route::post('post_product_in', [InController::class,'post_product_in']);

    Route::get('raw_m_out', [OutController::class,'raw_m_out']);
    Route::get('category_out/{id}', [OutController::class,'caterory_out']);
    Route::get('delete_product_out/{id}', [OutController::class,'delete_product_out']);
    Route::post('post_product_out', [OutController::class,'post_product_out']);
    Route::get('bill', [OutController::class,'bill']);
    Route::post('post_bill', [OutController::class,'post_bill']);
    Route::post('post_invoice', [OutController::class,'post_invoice']);

    Route::get('settings', [SettingsController::class,'settings']);
    Route::post('post_settings', [SettingsController::class,'post_settings']);
    Route::get('active_category/{category_id}', [SettingsController::class,'active_category']);
    Route::get('product_delete/{id}', [SettingsController::class,'product_delete']);
    Route::post('update_product', [SettingsController::class,'update_product']);

    // Reports
    Route::get('common_report', [CommonReportController::class,'common_report']);
    Route::post('post_common_report', [CommonReportController::class,'post_common_report']);
    Route::get('challan_report', [CommonReportController::class,'challan_report']);
    Route::get('post_challan_report', [CommonReportController::class,'post_challan_report']);

    Route::get('excel_report', [ExcelController::class,'excel_report']);
    Route::get('bill_report', [ExcelController::class,'bill_report']);
    Route::post('post_bill_report', [ExcelController::class,'post_bill_report']);
    Route::get('view_bill_report/{id}', [ExcelController::class,'view_bill_report']);

    Route::get('customer', [CustomerController::class,'index']);
    Route::post('post_customer', [CustomerController::class,'post_customer']);
    Route::post('update_customer', [CustomerController::class,'update_customer']);

    Route::get('mis_report_2019', [ExcelController::class,'mis_report_2019']);
    Route::get('mis_report_2018', [ExcelController::class,'mis_report_2018']);
    Route::get('mis_report_2017', [ExcelController::class,'mis_report_2017']);
    Route::get('mis_report', [ExcelController::class,'mis_report']);
    Route::post('post_mis_report', [ExcelController::class,'post_mis_report']);
    Route::get('mis_bill_report', [ExcelController::class,'mis_bill_report']);
    Route::post('post_mis_bill_report', [ExcelController::class,'post_mis_bill_report']);
    Route::get('mis_in_out', [ExcelController::class,'mis_in_out']);

    // Payroll
    Route::post('/payroll/store', [PayrollController::class,'store'])->name('payroll.store');
    Route::get('/payroll/generate/{action}/{payroll_slip_id}', [PayrollController::class,'generate']);
    Route::get('/payroll', [PayrollController::class,'index']);
    Route::any('/payroll/create', [PayrollController::class,'create'])->name('payroll.create');
    Route::get('/my_payroll', [PayrollController::class,'myPayroll']);
    Route::post('/my_payroll', [PayrollController::class,'myPayroll'])->name('payroll.myPayroll');
    Route::get('/all_contribution', [PayrollController::class,'allContribution']);
    Route::post('/all_contribution', [PayrollController::class,'allContribution'])->name('payroll.allContribution');

    // Tickets / Tasks / Comments
    Route::resource('ticket', TicketController::class);
    Route::post('updateTicketStatus', [TicketController::class,'updateTicketStatus'])->name('ticket.updateTicketStatus');
    Route::resource('ticket_comment', TicketCommentController::class)->only(['store','destroy']);
    Route::resource('ticket_note', TicketNoteController::class)->only(['store','update']);
    Route::resource('ticket_attachment', TicketAttachmentController::class)->only(['store','destroy']);
    Route::resource('task', TaskController::class);
    Route::post('updateTaskProgress', [TaskController::class,'updateTaskProgress'])->name('task.updateTaskProgress');
    Route::resource('comment', CommentController::class)->only(['store','destroy']);
    Route::resource('note', NoteController::class)->only(['store','update']);
    Route::resource('attachment', AttachmentController::class)->only(['store','destroy']);

    // Messages
    Route::get('message/compose', [MessageController::class,'compose']);
    Route::post('message', [MessageController::class,'store'])->name('message.store');
    Route::get('message/sent', [MessageController::class,'sent']);
    Route::get('message', [MessageController::class,'inbox']);
    Route::get('message/view/{id}/{token}', [MessageController::class,'view'])->name('message.view');
    Route::get('message/{id}/delete/{token}', [MessageController::class,'delete'])->name('message.delete');

    // Awards
    Route::resource('award', AwardController::class);
    Route::resource('award_type', AwardTypeController::class);

    // Applications
    Route::get('/application/{id}', [JobController::class,'applicationDetail']);
    Route::delete('deleteApplication/{id}', [JobController::class,'deleteApplication'])->name('application.deleteApplication');
    Route::patch('/updateApplicationStatus/{id}', [JobController::class,'updateApplicationStatus'])->name('application.updateApplicationStatus');

    // Roles & Config
    Route::resource('role', RoleController::class);
    Route::post('save-permission', [ConfigController::class,'savePermission'])->name('configuration.save_permission');
    Route::get('configuration', [ConfigController::class,'index']);
    Route::post('/configuration/leave', [ConfigController::class,'leave_details']);
    Route::post('/configuration/time', [ConfigController::class,'time_details']);
    Route::post('configuration', [ConfigController::class,'store'])->name('configuration.store');
    Route::post('office-time', [ConfigController::class,'officeTime'])->name('configuration.time');
    Route::post('sms-store', [ConfigController::class,'smsStore'])->name('configuration.smsStore');
    Route::post('mail-store', [ConfigController::class,'mailStore'])->name('configuration.mailStore');
    Route::post('job-store', [ConfigController::class,'jobStore'])->name('configuration.jobStore');

    // Custom Fields / Templates / Notices
    Route::resource('custom_field', CustomFieldController::class);
    Route::resource('leave_type', LeaveTypeController::class);
    Route::resource('document_type', DocumentTypeController::class);
    Route::resource('salary_type', SalaryTypeController::class);
    Route::resource('expense_head', ExpenseHeadController::class);
    Route::resource('template', TemplateController::class)->only(['index','update']);
    Route::resource('sms_template', SMSTemplateController::class)->only(['index','update']);
    Route::resource('notice', NoticeController::class);

    // SMS
    Route::post('sms', [SMSController::class,'store'])->name('sms.store');

    // Password change
    Route::get('/change_password', [EmployeeController::class,'changePassword']);
    Route::post('/change_password', [EmployeeController::class,'doChangePassword'])->name('change_password');
    Route::patch('/change_employee_password/{id}', [EmployeeController::class,'doChangeEmployeePassword'])->name('change_employee_password');
});

// <?php

// /*
// |--------------------------------------------------------------------------
// | Application Routes
// |--------------------------------------------------------------------------
// |
// | Here is where you can register all of the routes for an application.
// | It's a breeze. Simply tell Laravel the URIs it should respond to
// | and give it the controller to call when that URI is requested.
// |
// */
// //get('/testapi','Auth\AuthController@store');




// use Illuminate\Support\Facades\Route;

// /*
// |--------------------------------------------------------------------------
// | Guest Routes
// |--------------------------------------------------------------------------
// */


// Route::get('/', 'Auth\AuthController@showLoginForm');

// Route::get('/apply', 'JobController@apply');
// Route::post('/saveApplication', ['as' => 'job.saveApplication','uses' => 'JobController@saveApplication']);

// Route::group(['middleware' => 'guest'], function () {
// 	Route::get('/login', 'Auth\AuthController@showLoginForm')->name('login');
//     Route::post('/login', 'Auth\AuthController@login');
//     Route::get('password/email', 'Auth\PasswordController@getEmail');
//     Route::post('password/email', 'Auth\PasswordController@postEmail');
//     Route::get('password/reset/{token}', 'Auth\PasswordController@getReset');
//     Route::post('password/reset', 'Auth\PasswordController@postReset');

//     $config = \App\Classes\Helper::getConfiguration();
//     if (array_key_exists('installation_path', $config) && $config['installation_path'] == '') {
//         Route::resource('install', 'InstallController', ['only' => ['index', 'store']]);
//     }
// });

// /*
// |--------------------------------------------------------------------------
// | Authenticated Routes
// |--------------------------------------------------------------------------
// */
// Route::group(['middleware' => 'auth'], function () {

//     Route::get('dashboard','DashboardController@index');
//     Route::get('expirelist','ExpireListController@index');
//     Route::get('/logout', 'Auth\AuthController@getLogout');
//     Route::get('/payments', 'PaymentController@index');

//     // Languages
//     Route::resource('language', 'LanguageController');
//     Route::get('setLanguage/{locale}','LanguageController@setLanguage');
//     Route::post('language/addWords', ['as'=>'language.addWords','uses'=>'LanguageController@addWords']);
//     Route::patch('language/updateTranslation/{id}', ['as'=>'language.updateTranslation','uses'=>'LanguageController@updateTranslation']);

//     // Departments, Locations, Designations
//     Route::resource('department', 'DepartmentController');
//     Route::resource('location', 'LocationController');
//     Route::resource('designation', 'DesignationController');

//     // Training
//     Route::get('training/add', 'TrainingController@add_training');
//     Route::get('training/manage', 'TrainingController@add_new');
//     Route::get('training/report', 'TrainingController@report');
//     Route::resource('manage_training', 'Manage_TrainingController');
//     Route::get('training_type/{id}/edit','TrainingController@edit');
//     Route::resource('training', 'TrainingController');

//     // Employees
//     Route::get('employee/create', 'Auth\AuthController@getRegister');
//     Route::post('auth/register', 'Auth\AuthController@postRegister');
//     Route::resource('employee', 'EmployeeController', ['except' => ['create', 'store']]);
//     Route::patch('users/profile/{id}', ['as' => 'employee.profileUpdate', 'uses' => 'EmployeeController@profileUpdate']);
//     Route::patch('users/sms/{id}', ['as' => 'employee.sendEmployeeSMS', 'uses' => 'SMSController@sendEmployeeSMS']);

//     // Accounts / Documents / Dependents
//     Route::resource('bank_account', App\Http\Controllers\BankAccountController::class)->only(['store','destroy']);
//     Route::resource('document', App\Http\Controllers\DocumentController::class)->only(['store','destroy']);
//     Route::resource('dependent', App\Http\Controllers\DependentController::class)->only(['store','edit','destroy']);
//     Route::get('/dependent/add/{eid}', [App\Http\Controllers\DependentController::class,'add']);
//     Route::patch('/dependent', [App\Http\Controllers\DependentController::class,'store'])->name('dependent');


//     // Salary
//     Route::resource('salary', 'SalaryController',['only' => ['store', 'destroy']]); 
//     Route::get('/employee/welcomeEmail/{user_id}/{token}','TemplateController@welcomeEmail');

//     // Jobs / Expenses / Todos / Leaves / Holidays
//     Route::resource('job', 'JobController');
//     Route::resource('expense', 'ExpenseController');
//     Route::resource('todo', 'TodoController');
//     Route::resource('leave', 'LeaveController'); 
//     Route::post('leaveUpdateStatus', ['as' => 'leave.updateStatus', 'uses' => 'LeaveController@updateStatus']);
//     Route::resource('holiday', 'HolidayController');

//     // Assets
//     Route::resource('employeeasset', 'EmployeeAssetController');
//     Route::resource('asset', 'AssetController');
//     Route::resource('alias', 'AliasController');

//     // Clock / Attendance
//     Route::get('clock/in/{token}', ['as' => 'clock.in', 'uses' => 'ClockController@in']);
//     Route::get('clock/out/{token}', ['as' => 'clock.out', 'uses' => 'ClockController@out']);
//     Route::any('attendance', ['as'=>'clock.attendance','uses'=>'ClockController@attendance']);
//     Route::get('attendance_monthly', 'ClockController@attendanceMonthly');
//     Route::post('attendance_monthly', ['as'=>'clock.attendanceMonthlyReport','uses'=>'ClockController@attendanceMonthlyReport']);
//     Route::post('uploadAttendance',['as' => 'clock.uploadAttendance','uses' => 'ClockController@uploadAttendance']);
//     Route::get('update_attendance','ClockController@updateAttendance');
//     Route::post('updateAttendance',['as' => 'clock.updateAttendance','uses' => 'ClockController@updateStaffAttendance']);

//     // Product In/Out/Settings
//     Route::get('raw_m_in', 'InController@raw_m_in');
//     Route::get('caterory_in/{id}','InController@caterory_in');
//     Route::get('delete_product_in/{id}','InController@delete_product_in');
//     Route::post('post_product_in','InController@post_product_in');

//     Route::get('raw_m_out','OutController@raw_m_out');
//     Route::get('category_out/{id}','OutController@caterory_out');
//     Route::get('delete_product_out/{id}','OutController@delete_product_out');
//     Route::post('post_product_out','OutController@post_product_out');
//     Route::get('bill','OutController@bill');
//     Route::post('post_bill','OutController@post_bill');
//     Route::post('post_invoice','OutController@post_invoice');

//     Route::get('settings','SettingsController@settings');
//     Route::post('post_settings','SettingsController@post_settings');
//     Route::get('active_category/{category_id}','SettingsController@active_category');
//     Route::get('product_delete/{id}','SettingsController@product_delete');
//     Route::post('update_product','SettingsController@update_product');

//     // Reports
//     Route::get('common_report','common_Report_Controller@common_report');
//     Route::post('post_common_report','common_Report_Controller@post_common_report');
//     Route::get('challan_report','common_Report_Controller@challan_report');
//     Route::get('post_challan_report','common_Report_Controller@post_challan_report');

//     Route::get('excel_report','Excel_Controller@excel_report');
//     Route::get('bill_report','Excel_Controller@bill_report');
//     Route::post('post_bill_report','Excel_Controller@post_bill_report');
//     Route::get('view_bill_report/{id}','Excel_Controller@view_bill_report');

//     Route::get('customer', 'CustomerController@index');
//     Route::post('post_customer','CustomerController@post_customer');
//     Route::post('update_customer','CustomerController@update_customer');

//     Route::get('mis_report_2019','Excel_Controller@mis_report_2019');
//     Route::get('mis_report_2018','Excel_Controller@mis_report_2018');
//     Route::get('mis_report_2017','Excel_Controller@mis_report_2017');
//     Route::get('mis_report','Excel_Controller@mis_report');
//     Route::post('post_mis_report','Excel_Controller@post_mis_report');
//     Route::get('mis_bill_report','Excel_Controller@mis_bill_report');
//     Route::post('post_mis_bill_report','Excel_Controller@post_mis_bill_report');
//     Route::get('mis_in_out','Excel_Controller@mis_in_out');

//     // Payroll
//     Route::post('/payroll/store',['as' => 'payroll.store','uses' => 'PayrollController@store']);
//     Route::get('/payroll/generate/{action}/{payroll_slip_id}','PayrollController@generate');
//     Route::get('/payroll','PayrollController@index');
//     Route::any('/payroll/create',['as' => 'payroll.create','uses' => 'PayrollController@create']);
//     Route::get('/my_payroll','PayrollController@myPayroll');
//     Route::post('/my_payroll',['as' => 'payroll.myPayroll','uses' => 'PayrollController@myPayroll']);
//     Route::get('/all_contribution','PayrollController@allContribution');
//     Route::post('/all_contribution',['as' => 'payroll.allContribution','uses' => 'PayrollController@allContribution']);

//     // Tickets / Tasks / Comments
//     Route::resource('ticket', 'TicketController');
//     Route::post('updateTicketStatus', ['as' => 'ticket.updateTicketStatus', 'uses' => 'TicketController@updateTicketStatus']);
//     Route::resource('ticket_comment', 'TicketCommentController',['only' => ['store','destroy']]); 
//     Route::resource('ticket_note', 'TicketNoteController',['only' => ['store','update']]); 
//     Route::resource('ticket_attachment', 'TicketAttachmentController',['only' => ['store','destroy']]); 
//     Route::resource('task', 'TaskController'); 
//     Route::post('updateTaskProgress', ['as' => 'task.updateTaskProgress', 'uses' => 'TaskController@updateTaskProgress']);
//     Route::resource('comment', 'CommentController',['only' => ['store','destroy']]); 
//     Route::resource('note', 'NoteController',['only' => ['store','update']]); 
//     Route::resource('attachment', 'AttachmentController',['only' => ['store','destroy']]); 

//     // Messages
//     Route::get('message/compose', 'MessageController@compose'); 
//     Route::post('message', ['as' => 'message.store', 'uses' => 'MessageController@store']);
//     Route::get('message/sent','MessageController@sent'); 
//     Route::get('message','MessageController@inbox'); 
//     Route::get('message/view/{id}/{token}', ['as' => 'message.view', 'uses' => 'MessageController@view']);
//     Route::get('message/{id}/delete/{token}', ['as' => 'message.delete', 'uses' => 'MessageController@delete']);

//     // Awards
//     Route::resource('award', 'AwardController'); 
//     Route::resource('award_type', 'AwardTypeController'); 

//     // Applications
//     Route::get('/application/{id}','JobController@applicationDetail');
//     Route::delete('deleteApplication/{id',['uses' => 'JobController@deleteApplication','as' => 'application.deleteApplication']);
//     Route::patch('/updateApplicationStatus/{id}', ['as' => 'application.updateApplicationStatus','uses' => 'JobController@updateApplicationStatus']);

//     // Roles & Config
//     Route::resource('role', 'RoleController'); 
//     Route::post('save-permission',['as' => 'configuration.save_permission','uses' => 'ConfigController@savePermission']);
//     Route::get('configuration', 'ConfigController@index');
//     Route::post('/configuration/leave','ConfigController@leave_details');
//     Route::post('/configuration/time','ConfigController@time_details');
//     Route::post('configuration', ['as' => 'configuration.store','uses' => 'ConfigController@store']); 
//     Route::post('office-time', ['as' => 'configuration.time','uses' => 'ConfigController@officeTime']); 
//     Route::post('sms-store', ['as' => 'configuration.smsStore','uses' => 'ConfigController@smsStore']); 
//     Route::post('mail-store', ['as' => 'configuration.mailStore','uses' => 'ConfigController@mailStore']); 
//     Route::post('job-store', ['as' => 'configuration.jobStore','uses' => 'ConfigController@jobStore']); 

//     // Custom Fields / Templates / Notices
//     Route::resource('custom_field', 'CustomFieldController'); 
//     Route::resource('leave_type', 'LeaveTypeController'); 
//     Route::resource('document_type', 'DocumentTypeController'); 
//     Route::resource('salary_type', 'SalaryTypeController'); 
//     Route::resource('expense_head', 'ExpenseHeadController'); 
//     Route::resource('template', 'TemplateController',['only' => ['index', 'update']]); 
//     Route::resource('sms_template', 'SMSTemplateController',['only' => ['index', 'update']]); 
//     Route::resource('notice', 'NoticeController'); 

//     // SMS
//     Route::post('sms', ['as'=>'sms.store','uses'=>'SMSController@store']); 

//     // Password change
//     Route::get('/change_password', 'EmployeeController@changePassword');
//     Route::post('/change_password',['as'=>'change_password','uses' =>'EmployeeController@doChangePassword']);
//     Route::patch('/change_employee_password/{id}',['as'=>'change_employee_password','uses' =>'EmployeeController@doChangeEmployeePassword']);
// });
